#include "SMInterface.h"
#include <iostream>

using namespace std;
using namespace boost;



const string TSMObject::defaultSMName = "VCDESMInterface";


TSMObject::TSMObject( const int sizeMB, const std::string name, const bool _destruct, const int retainedHistoryMS)
	: smManager( NULL), destruct( _destruct), memoryName( name)
{
	if( destruct){
		try{
			interprocess::shared_memory_object::remove( memoryName.data());
		} catch(...){} 
	}

	smSegment = interprocess::managed_shared_memory( interprocess::open_or_create, memoryName.data(), sizeMB * 1000000);

	smManager = smSegment.find_or_construct<TSMManager>( interprocess::unique_instance) ( retainedHistoryMS, TVoidAllocator( smSegment.get_segment_manager()));
};

TSMObject::~TSMObject()
{
	{
		// deregister all image queues
		vector< string> toDelete;
		for( std::map< std::string, bool>::iterator it = registeredQueues.begin(); it != registeredQueues.end(); it++){
			toDelete.push_back( it->first);
		}
		for( int i = 0; i < (int)toDelete.size(); i++){
			deregisterQueue( toDelete[ i]);
		}
	}

	{
		// deregister all float queues
		vector< string> toDelete;
		for( std::map< std::string, bool>::iterator it = registeredFloatQueues.begin(); it != registeredFloatQueues.end(); it++){
			toDelete.push_back( it->first);
		}
		for( int i = 0; i < (int)toDelete.size(); i++){
			deregisterFloatQueue( toDelete[ i]);
		}
	}

	{
		// destroy all temp images 
		vector< IplImage *> toDelete;
		for( std::map< IplImage *, TSMImage *>::iterator it = tempImages.begin(); it != tempImages.end(); it++){
			toDelete.push_back( it->first);
		}
		for( int i = 0; i < (int)toDelete.size(); i++){
			discardImage( toDelete[ i]);
		}
	}


	{
		// release all images
		vector< IplImage *> toDelete;
		for( std::map< IplImage *, std::pair< long long, std::string> >::iterator it = ptrImgMap.begin(); it != ptrImgMap.end(); it++){
			toDelete.push_back( it->first);
		}
		for( int i = 0; i < (int)toDelete.size(); i++){
			discardImage( toDelete[ i]);
		}
	}

	// derequest rest of the images
	vector< pair< string, long long> > toDelete;
	for( std::map< std::string, std::map< long long, IplImage * > >::iterator it = queImgMap.begin(); it != queImgMap.end(); it++)
	{
		for( std::map< long long, IplImage * >::iterator it2 = it->second.begin(); it2 != it->second.end(); it2++){
			toDelete.push_back( pair<string, long long>( it->first, it2->first));
		}
	}
	for( int i = 0; i < (int)toDelete.size(); i++){
		smManager->returnImage( toDelete[ i].first, toDelete[ i].second);
	}

}

void TSMObject::cleanup(){

	smManager->cleanup();
}

IplImage * TSMObject::createIplImage( const CvSize size, const int depth, const int nChannels)
{
	//std::cout << "free space" << smSegment.get_free_memory() << std::endl;
	TSMImage *tempImg = smSegment.construct<TSMImage>( interprocess::anonymous_instance) ( size, depth, nChannels, TVoidAllocator( smSegment.get_segment_manager()));

	IplImage * tempIpl = tempImg->createIplImage();

	tempImages[ tempIpl] = tempImg;

	return tempIpl;
}

void TSMObject::discardImage( IplImage * &img)
{
	if( tempImages.find( img) == tempImages.end()){
		throw string( "TSMObject-discardImage(): trying to discard IplImage* which was not cretated inside this TSMObject instance.");
	}

	smSegment.destroy_ptr( tempImages[ img]);

	tempImages.erase( tempImages.find( img));

	cvReleaseImageHeader( &img);

	img = NULL;
}

void TSMObject::pushImage( const std::string &queue, IplImage *&img, long long timestamp)
{
	if( tempImages.find( img) == tempImages.end()){
		throw string( "TSMObject-pushImage(): trying to discard IplImage* which was not cretated inside this TSMObject instance.");
	}

	smManager->pushImage( queue, tempImages[ img], timestamp);

	tempImages.erase( tempImages.find( img));

	cvReleaseImageHeader( &img);
	img = NULL;
}

void TSMObject::getNewest( const std::string queue, long long &timestamp, IplImage *&img)
{
	img = NULL;

	while( img == NULL){

		while( (timestamp = smManager->getNewest( queue)) == -1){
			smManager->waitForChange();
		}

		// check if this image has been already requested (based on queue and timestamp)
		if( queImgMap.find( queue) != queImgMap.end() && queImgMap[ queue].find( timestamp) != queImgMap[ queue].end()){

			if( queImgMap[ queue][ timestamp] != NULL){ // we already have the image
				timestamp = -1;
				img = NULL;
				return;
			}

			img = smManager->getImage( queue, timestamp, false); // the img was requested(registered), but it was not retrieved
		
		} else {
			img = smManager->getImage( queue, timestamp, true);
		}
	}

	// remember the reqested image
	queImgMap[ queue][ timestamp] = img;
	ptrImgMap[ img] = pair< long long, std::string>( timestamp, queue);
}

void TSMObject::getImage( const std::string queue, long long timestamp, IplImage *&img)
{

	if( queImgMap.find( queue) != queImgMap.end() && queImgMap[ queue].find( timestamp) != queImgMap[ queue].end()){

		if( queImgMap[ queue][ timestamp] != NULL){ // we already have the image
			timestamp = -1;
			img = NULL;
			return;
		}

		int count = 0;
		// the img was requested(registered), but it was not retrieved yet
		while( (img = smManager->getImage( queue, timestamp, false)) == NULL && timestamp >= smManager->getNewestTimestamp()){
			smManager->waitForChange();
		}

		if( img == NULL){ // we have requested it, but it can not be ever retrieved, we have derequest it
			smManager->returnImage( queue, timestamp);
			queImgMap[ queue].erase( timestamp);
		}
	
	} else {

		while( (img = smManager->getImage( queue, timestamp, true)) == NULL && timestamp >= smManager->getNewestTimestamp()){
			smManager->waitForChange();
		}
	}

	if( img != NULL){
		// remember the reqested image
		queImgMap[ queue][ timestamp] = img;
		ptrImgMap[ img] = pair< long long, std::string>( timestamp, queue);
	}
}

long long TSMObject::getNewestTimestamp( )
{
	return smManager->getNewestTimestamp();
}

void TSMObject::requestTimestamp( long long timestamp)
{
	for( std::map< std::string, bool>::const_iterator it = registeredQueues.begin(); it != registeredQueues.end(); it++){

		if( it->second && (queImgMap.find( it->first) != queImgMap.end() || queImgMap[ it->first].find( timestamp) == queImgMap[ it->first].end())){

			smManager->registerImage( it->first, timestamp);
			queImgMap[ it->first][ timestamp] = NULL;
		}
	}
}



void TSMObject::returnImage( IplImage * &img)
{

	if( ptrImgMap.find( img) == ptrImgMap.end()){
		return;
	}

	const string queue = ptrImgMap[img].second;
	const long long timestamp = ptrImgMap[img].first;

	smManager->returnImage( queue, timestamp);

	ptrImgMap.erase( img);
	queImgMap[ queue].erase( timestamp);

	cvReleaseImageHeader( &img);
	img = NULL;
}

void TSMObject::returnTimestamp( long long timestamp)
{
	for( std::map< std::string, bool>::const_iterator it = registeredQueues.begin(); it != registeredQueues.end(); it++){

		if( queImgMap.find( it->first) != queImgMap.end() && queImgMap[ it->first].find( timestamp) != queImgMap[ it->first].end()){

			smManager->returnImage( it->first, timestamp);

			if( queImgMap[ it->first][ timestamp] != NULL){
				ptrImgMap.erase( queImgMap[ it->first][ timestamp]);
				
				cvReleaseImageHeader( &(queImgMap[ it->first][ timestamp]));

			}
			queImgMap[ it->first].erase( timestamp);
		}
	}
}




//bool TSMObject::pushImage( const std::string queue, IplImage *&, long long timestamp);



void TSMObject::registerQueue( const std::string &queue)
{
	if( registeredQueues.find( queue) == registeredQueues.end()){
		smManager->registerQueue( queue);
		registeredQueues[ queue] = true;
	}
}
	
void TSMObject::deregisterQueue( const std::string &queue)
{
	if( registeredQueues.find( queue) != registeredQueues.end()){
		smManager->deregisterQueue( queue);
		registeredQueues.erase( queue);
	}
}

void TSMObject::getActiveQueues( std::map< std::string, bool> &activeQueues)
{
	smManager->getActiveQueues( activeQueues);
}

void TSMObject::push( const std::string &queueName, const std::vector< float> &data, long long timestamp)
{
	smManager->push( queueName, data, timestamp);
}
	
void TSMObject::get( const std::string &queueName, const long long timestamp, std::vector< std::vector< float> > &res)
{
	smManager->get( queueName, timestamp, res);	
}

void TSMObject::getNewer( const std::string & queueName, const long long timestamp, std::multimap< long long, std::vector< float> > &res)
{
	smManager->getNewer( queueName, timestamp, res);
}
	
void TSMObject::getNewest( const std::string & queueName, long long &timestamp, std::vector< std::vector< float> > &res)
{
	smManager->getNewest( queueName, timestamp, res);
}

void TSMObject::registerFloatQueue( const std::string &queue)
{
	if( registeredFloatQueues.find( queue) == registeredFloatQueues.end()){
		smManager->registerFloatQueue( queue);
		registeredFloatQueues[ queue] = true;
	}
}
	
void TSMObject::deregisterFloatQueue( const std::string &queue)
{
	if( registeredFloatQueues.find( queue) != registeredFloatQueues.end()){
		smManager->deregisterFloatQueue( queue);
		registeredQueues.erase( queue);
	}
	void registeredFloatQueues( const std::string &queue);
}

void TSMObject::getActiveFloatQueues( std::map< std::string, bool> &activeQueues)
{
	smManager->getActiveFloatQueues( activeQueues);
}
